﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SQL_DEFEND
{
    class RuntimeAccess
    {
        public static System.Reflection.Assembly loadAsmFromGAC(string target)
        {
            System.Reflection.Assembly a = System.Reflection.Assembly.Load(target);
            return a;
        }
        public static System.Reflection.Assembly loadAsmFromResource(string target, System.Reflection.Assembly targetAssemblyIN)
        {
            System.IO.Stream dll = targetAssemblyIN.GetManifestResourceStream(target);
            System.IO.BinaryReader br = new System.IO.BinaryReader(dll);
            System.Byte[] b = new byte[dll.Length];
            br.Read(b, 0, b.Length);
            System.Reflection.Assembly newASM = System.Reflection.Assembly.Load(b);
            return newASM;
        }
      
        //public static void l(System.Reflection.Assembly asmIN, string targetObjectTypeIN)
        //{
        //    System.Type t = a.GetType(targetObjectTypeIN);
        //    if (t == null)
        //        t = a.GetType("Microsoft.SqlServer.Management.Common");

        //    System.Reflection.ConstructorInfo ci = t.GetConstructor(new System.Type[] { typeof(string), typeof(string), typeof(string) });
        //    object target = ci.Invoke(new object[] { server, user, pass });

        //    System.Reflection.BindingFlags fields = System.Reflection.BindingFlags.Public | System.Reflection.BindingFlags.Instance;
        //    System.Reflection.MethodInfo mi = t.GetMethod("ChangePassword", new System.Type[] { typeof(string) });
        //    mi.Invoke(target, new object[] { newPassword });
        //}
        public static object RunFromGAC(string dllName, string objectName, string funcName, string[] conParams, string[] methodParamsIN)
        {
            object objNew = MakeObjectFromGAC(dllName, objectName, conParams);
            object dataOut = RunMethod(objNew, funcName, methodParamsIN);
            return dataOut;

        }
        public static object RunFromResource(string dllName, string objectName, string funcName, string[] conParams, string[] methodParamsIN, System.Reflection.Assembly targetAssemblyIN)
        {
            object objNew = MakeObjectFromResource(dllName, objectName, conParams,targetAssemblyIN);
            object dataOut = RunMethod(objNew, funcName, methodParamsIN);
            return dataOut;

        }
        public static object MakeObjectFromGAC(string asmNameIN, string targetObjectTypeIN, object[] constructorParamsIN)
        {
            System.Reflection.Assembly a = loadAsmFromGAC(asmNameIN);
            System.Type t = a.GetType(targetObjectTypeIN);
            if (t != null)
            {
                object objNew = makeNew(t, constructorParamsIN);
                return objNew;
            }
            else
                return null;
        }
        public static object MakeObjectFromResource(string asmNameIN, string targetObjectTypeIN, object[] constructorParamsIN, System.Reflection.Assembly targetAssemblyIN)
        {
            System.Reflection.Assembly a = loadAsmFromResource(asmNameIN, targetAssemblyIN);
            System.Type t = a.GetType(targetObjectTypeIN);
            object objNew = makeNew(t, constructorParamsIN);
            return objNew;
        }
        public static object makeNew(Type typeIN, object[] constructorParamsIN)
        {
            System.Type[] conParamTypes = new Type[constructorParamsIN.Length];
            for (int i = 0; i < constructorParamsIN.Length; i++)
            {
                conParamTypes[i] = constructorParamsIN[i].GetType();
            }
            System.Reflection.ConstructorInfo ci = typeIN.GetConstructor(conParamTypes);
            object target = ci.Invoke(constructorParamsIN);
            return target;
        }
        public static object RunMethod(object targetIN, string targetMethodIN, object[] paramIN)
        {
            System.Type[] ParamTypes = new Type[paramIN.Length];
            for (int i = 0; i < paramIN.Length; i++)
            {
                ParamTypes[i] = paramIN[i].GetType();
            }
            System.Reflection.MethodInfo mi = targetIN.GetType().GetMethod(targetMethodIN, ParamTypes);
            if(mi==null)
             mi = targetIN.GetType().GetMethod(targetMethodIN);
            object objOut = mi.Invoke(targetIN, paramIN);

            return objOut;
        }
    }
}
